/*****************************************************************************
******************************************************************************
** COPYRIGHT:    (c) 2004 Rohde & Schwarz, Munich
** MODULE:       wavfile.h
** ABBREVIATION:   
** COMPILER:     VC++ 5.0
** LANGUAGE:     C/C++
** AUTHOR:       Florian Behrens
** ABSTRACT:     
** PREMISES:     
** REMARKS:      
** HISTORY:      
**  2003-09-11: (FB) Version 3.71: Creation
** REVIEW:       
******************************************************************************/

#ifndef _WAVFILE_H_
#define _WAVFILE_H_

/* INCLUDE FILES ***************************************************************/

#include <stdio.h>

/* GLOBAL DEFINES ************************************************************/

class CWAVFile  
{
public:
	CWAVFile();
	virtual ~CWAVFile();

  bool Open(unsigned unSampleRate, unsigned unChannelCount, 
            unsigned unSampleWidth);
  bool Close();

  unsigned write(void* pvData, unsigned unByteCount);

  void     SetFilename(char* pcFilename);
  char*    GetFilename() const;
  unsigned GetSampleRate() const;
  unsigned GetChannelCount() const;
  unsigned GetSampleWidth() const;
  bool     IsOpen() const;

protected:
  char    *m_pcFilename;
  FILE    *m_fFile;
  unsigned m_unFmtChunkPosition;
  unsigned m_unDataChunkPosition;
  unsigned m_unByteCount;
  unsigned m_unSampleRate;
  unsigned m_unChannelCount;
  unsigned m_unSampleWidth;

  bool PrepareFile();
  bool PostprocWaveFile();
};

#endif // _WAVFILE_H_
/* End of file ***************************************************************/
